﻿<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Zmiana ID wydziału</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
		
	//Zapytanie do uruchomienia z okna SQL po ustawieniu wydziałów w listach płac.
	/*
update wypelementy
	set wypelementy.Wydzial=l.Wydzial
	from wyplaty as w, listyplac as l
	where wypelementy.Wyplata=w.ID and w.ListaPlac=l.ID	
	*/


            public class Params: ContextBase {

                public Params(Context context)
                    : base(context) {
                }

                Wydzial wydział;
                [Soneta.Business.Required]                
                public Wydzial Wydział {
                    get { return wydział; }
                    set {
                        wydział = value; 
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            Wydzial wydział;        
            [Context]
            public Params Pars {
                set { wydział = value.Wydział; }
            }
            
    Row[] rows;
    [Context]
    public Row[] Rows {
		set { rows = value; }
    }
			
	void OnContextLoad(Object sender, EventArgs args) {
		Database db = dc.Session.Login.Database;
		Response.Write("-- WYDZIAŁ --<br>");
		Response.Write(wydział.Nazwa + "<br>");
		Response.Write("-- LISTY --<br>");
		try {
			using (IDatabaseTransaction t = db.Logout())
                using (Connection cn = db.OpenConnection(DatabaseType.Operational)) {
                    foreach (ListaPlac lp in rows) {
                        string cmd = string.Format("update listyplac set wydzial={0} where id={1}",
                            wydział.ID,
                            lp.ID);
                        cn.ExecuteCommand(ExecuteMode.NonQuery, cmd);
                        Response.Write(lp.Numer + "<br>");
                    }
				t.Commit();
			}	
			Response.Write("-- GOTOWE --");
		} catch (Exception e) {
			Response.Write("-- BŁĄD --<br>");
			Response.Write(e.Message);			
		}
	}
			
	//Pomocne w trakcie szukania błądów
	static void Msg(object obj) {
	}			
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[],Soneta.Business"></ea:DataContext>
		</FORM>
	</BODY>
</HTML>

